﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="MarqueeManager.aspx.cs" Inherits="DimoNetwork.ProxyWeb.SysRoot.MarqueeManager" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title></title>
    <script src="/js/jquery-1.11.2.min.js"></script>
    <link href="css/style.css" rel="stylesheet" type="text/css" />
    <link href="css/select.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="js/jquery.idTabs.min.js"></script>
    <script type="text/javascript" src="js/select-ui.min.js"></script>
    <script src="../js/iColorPicker.js"></script>
    <style>
        input {
            width: 60px;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function (e) {
            $(".select3").uedSelect({
                width: 100
            });
            $("#<%=hdTextColor1.ClientID %>").val("000000");
        });


        
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div class="place">
            <span>位置：</span>
            <ul class="placeul">
                <li><a href="/SysRoot/index.aspx">首页</a></li>
                <li><a href="#">发广告</a></li>
            </ul>
        </div>

        <div class="formbody">
            <div class="itab">
                <ul id="tabUl">
                    <li><a href="#tab1">发广告</a></li>
                    <li><a href="#tab2" onclick="location.href='/SysRoot/MarqueeList.aspx#tab2'">发送记录</a></li>
                </ul>
            </div>
            <div>
                <div class="formtitle">
                    <span>发广告</span>
                </div>
                <ul class="forminfo">
                    <li>
                        <label>单条价格：</label><b runat="server" id="txtSendPrice" style="padding-top: 10px;"></b>&nbsp;金币
                    </li>
                    <li>
                        <label>发送次数：</label><input name="" type="text" class="dfinput" value="1" runat="server" id="txtSendCounts" maxlength="200" style="width: 200px;" />
                    </li>

                    <li>
                        <label>消息内容：</label>
                        <input name="" type="text" class="iColorPicker" runat="server" id="txtContent"  maxlength="200" style="width: 700px; height:30px;border:1px solid #a7b5bc;"  />
                        <input type="hidden" runat="server" value="" id="hdTextColor1" />
                    </li>
                </ul>
                <ul class="forminfo">
                    <li>
                        <asp:Button ID="btnSubmit" runat="server" CssClass="btn" Text="确定发送" OnClientClick="return validate();" OnClick="BtnSubmit_Click" />
                    </li>
                </ul>
                <br />
                <br />
            </div>
        </div>
    </form>
</body>
</html>
<script type="text/javascript" src="/js/dialog-min.js"></script>
<script type="text/javascript" src="/js/dialog-plus-min.js"></script>
<link href="/css/ui-dialog.css" rel="stylesheet" type="text/css" />
<script type="text/javascript">
    $("#tabUl").idTabs("tab1");
    function validate() {
        var sendCounts = $("#<%=txtSendCounts.ClientID %>").val();
        var content = $("#<%=txtContent.ClientID %>").val();
        if (sendCounts == "" || sendCounts.indexOf(".") > -1 || isNaN(sendCounts) || parseFloat(sendCounts) < 0 || parseFloat(sendCounts) < 1 || parseFloat(sendCounts) > 15) {
            showDialog("发送次数只能为0-15之间的数字。");
            return false;
        }
        if (content == "" || content.length == 0 || content.length > 56) {
            showDialog("消息内容填写错误，消息长度必须在 1-40间。");
            return false;
        }

        var sendPrice = parseFloat($("#<%=txtSendPrice.ClientID %>").text().replace(",", "")) * sendCounts;


        if (confirm("确定要花费" + sendPrice + "金币，发送消息吗？")) {
            var styleArr1 = $("#<%=txtContent.ClientID %>").attr("style").split(';');
            for (var i = 0; i < styleArr1.length; i++) {
                var thisStyle = styleArr1[i];
                if (thisStyle != null && thisStyle != '' && thisStyle.toUpperCase().indexOf("COLOR") > -1) {
                    $("#<%=hdTextColor1.ClientID %>").val(thisStyle.split(':')[1].replace("#", ""));
                }
            }
            return true;
        }
        return false;
    }


    function showDialog(msg) {
        var d = dialog({
            title: '温馨提示',
            content: msg,
            cancel: false,
            ok: function () { }
        });
        d.show();
    }

</script>
